/*******************************************************************************
 *
 *      A U D I O   R E C O R D E R    M E N U   S Y S T E M
 *
 *      Copyright A Levido 2013 - All Rights Reserved
 *
 ******************************************************************************/
#ifndef MENU_H
#define MENU_H
#include "system.h"
#include <setjmp.h>
#include "graphics.h"


/* Functions & Macros *********************************************************/
/** Initialise menu system */
void menuInit(void);

/** Process menu events
 * @param event Event to process */
void menuProcess(EVENT event);

/** Get USB Mode*
 *  @returns zero of false, non-zero if true */
UINT32 menuGetUSBMode(void);

/** error macro */
extern UINT32 errSource;

volatile BOOL g_disable_error_throw;
#define throwError(x, loc)   { errSource = loc; if( !g_disable_error_throw ) { if( inInterruptHandler ) longjmp(intJump, (x)); else longjmp(errJump, (x)); } }

/* Function Related to buttons */
void doSourceButton(UINT16 code);
void doSortButton(UINT16 code);
void doPlaySingleMultiButton(UINT16 code);
void doConfigButton(UINT16 code);
void doMuteButton(UINT16 code);
void doStopButton(UINT16 code);
void doPlayButton(UINT16 code);
void doRecordButton(UINT16 code);
void doIncRecLvl(UINT16 code);
void doDecRecLvl(UINT16 code);
void doIncVol(UINT16 code);
void doDecVol(UINT16 code);
void doIncFile(UINT16 code);
void doDecFile(UINT16 code);
void doSetTime(UINT16 code);
void doSetDate(UINT16 code);
void doSetFname(UINT16 code);
void doConfigButton(UINT16 code);
void doCfgBack(UINT16 code);
void doIncRate(UINT16 code);
void doDecRate(UINT16 code);
void doIncBacklight(UINT16 code);
void doDecBacklight(UINT16 code);
void doErrReturn(UINT16 code);
void doNothing(UINT16 code);
void doIncHours(UINT16 code);
void doDecHours(UINT16 code);
void doIncMins(UINT16 code);
void doDecMins(UINT16 code);
void doIncSecs(UINT16 code);
void doDecSecs(UINT16 code);
void doIncYears(UINT16 code);
void doDecYears(UINT16 code);
void doIncMonths(UINT16 code);
void doDecMonths(UINT16 code);
void doIncDays(UINT16 code);
void doDecDays(UINT16 code);
void doPausePlay(UINT16 code);
void doSkipFwd(UINT16 code);
void doSkipBck(UINT16 code);
void doPauseRec(UINT16 code);
void doSkipRec(UINT16 code);
void doStopRec(UINT16 code);
void doSkipForward(UINT16 code);
void doSkipBack(UINT16 code);
void doUSBButton(UINT16 code);
void doDirUp(UINT16 code);
void doDirDown(UINT16 code);
void doAbout(UINT16 code);
void doUpdate(UINT16 code);
void doReadFiles(void);
void doPowerFail(void);
void doMount(void);
void doUSBAttach();
void checkUSB(void);

/* Dimensions ****************************************************************/
#define TITLE_TOP       3
#define TITLE_HEIGHT    19

#define LINE_CENTRE     23
#define LINE1_TOP       25
#define LINE1_HEIGHT    29
#define LINE2_TOP       54
#define LINE2_HEIGHT    30

#define BTN_HEIGHT      45
#define BTN_ROW1        90
#define BTN_ROW2        144
#define BTN_ROW3        198
#define BTN_ROW4        252
#define DATE_TOP        300
#define DATE_HEIGHT     20

#define BTN_COL1        6//3
#define BTN_COL2        85//82
#define BTN_COL3        164//161
#define BTN_COL4        234//237
#define BTN_WIDTH       70//75

#define RAD             0
#define BTN_HALF_W      35//38
#define BTN_HALF_H      23

/* Colours ********************************************************************/
/* Buttons */

#define CONFIG_COL                  PURPLE
#define MUTE_COL                    BROWN
#define RECORD_COL                  RED
#define STOP_COL                    BLACK
#define SOURCE_COL                  DK_BLUE
#define PLAY_COL                    GREEN
#define PREV_COL                    BLACK
#define NEXT_COL                    BLACK
#define SET_TIME_COL                BLUE
#define SET_DATE_COL                BLUE
#define DONE_COL                    BLACK
#define ERR_RTN_COL                 RED
#define USB_COL                     DK_BLUE
#define PAUSE_PLAY_COL              GREEN
#define SKIP_PLAY_COL               GREEN
#define PAUSE_REC_COL               RED
#define SKIP_REC_COL                RED
#define SORT_COL                    DK_BLUE
#define PLAY_SINGLE_MULTI_COL       BLUE

/* Clickers */
#define REC_LVL_COL                 ORANGE
#define FILE_COL                    BLUE
#define VOL_COL                     GREEN
#define REC_RATE_COL                PURPLE
#define SET_BACKLIGHT_COL           OLIVE
#define SET_HR_COL                  DK_BLUE
#define SET_MIN_COL                 DK_BLUE
#define SET_SEC_COL                 DK_BLUE
#define SET_YR_COL                  DK_BLUE
#define SET_MON_COL                 DK_BLUE
#define SET_DAY_COL                 DK_BLUE

/* See also widgets.h for background, text,  error and greyed colours*/
#endif
